/*
 * Decompiled with CFR 0.152.
 */
package br.com.okeaproject.project.controller;

import br.com.okeaproject.project.dto.NovoMembroDTO;
import br.com.okeaproject.project.dto.NovoProjetoDTO;
import br.com.okeaproject.project.entity.MembroProjeto;
import br.com.okeaproject.project.entity.Papel;
import br.com.okeaproject.project.entity.Projeto;
import br.com.okeaproject.project.entity.Tarefa;
import br.com.okeaproject.project.entity.Usuario;
import br.com.okeaproject.project.repository.MembroProjetoRepository;
import br.com.okeaproject.project.repository.PapelRepository;
import br.com.okeaproject.project.repository.ProjetoRepository;
import br.com.okeaproject.project.repository.TarefaRepository;
import br.com.okeaproject.project.repository.UsuarioRepository;
import br.com.okeaproject.project.service.GeradorCronogramaService;
import br.com.okeaproject.project.service.MembroProjetoService;
import br.com.okeaproject.project.service.ProjetoService;
import jakarta.transaction.Transactional;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/projetos"})
public class ProjetoController {
    @Autowired
    private ProjetoService projetoService;
    @Autowired
    private MembroProjetoService membroProjetoService;
    @Autowired
    private TarefaRepository tarefaRepository;
    @Autowired
    private ProjetoRepository projetoRepository;
    @Autowired
    private UsuarioRepository usuarioRepository;
    @Autowired
    private PapelRepository papelRepository;
    @Autowired
    private MembroProjetoRepository membroProjetoRepository;
    @Autowired
    private GeradorCronogramaService geradorService;

    @PostMapping
    @Transactional
    public Projeto criarProjetoCompleto(@RequestBody NovoProjetoDTO dto) {
        Projeto projeto = new Projeto();
        projeto.setNome(dto.getNome());
        projeto.setDataInicio(dto.getDataInicio());
        projeto.setDataFimPrevista(dto.getDataInicio().plusMonths(1L));
        projeto = (Projeto)this.projetoRepository.save((Object)projeto);
        if (dto.getEquipe() != null) {
            for (NovoProjetoDTO.MembroItemDTO item : dto.getEquipe()) {
                Usuario usuario = (Usuario)this.usuarioRepository.findById((Object)item.getUsuarioId()).orElseThrow(() -> new RuntimeException("Usu\u00e1rio n\u00e3o encontrado"));
                Papel papel = (Papel)this.papelRepository.findById((Object)item.getPapelId()).orElseThrow(() -> new RuntimeException("Papel n\u00e3o encontrado"));
                MembroProjeto membro = new MembroProjeto();
                membro.setProjeto(projeto);
                membro.setUsuario(usuario);
                membro.setPapeisAtribuidos(List.of(papel));
                membro = (MembroProjeto)this.membroProjetoRepository.save((Object)membro);
                this.geradorService.gerarTarefasParaNovoMembro(membro);
            }
        }
        return projeto;
    }

    @GetMapping
    public List<Projeto> listarProjetos() {
        return this.projetoService.listarTodos();
    }

    @GetMapping(value={"/{id}"})
    public Projeto buscarPorId(@PathVariable Long id) {
        return this.projetoService.buscarPorId(id);
    }

    @PostMapping(value={"/{projetoId}/membros"})
    public MembroProjeto adicionarMembro(@PathVariable Long projetoId, @RequestBody NovoMembroDTO dto) {
        return this.membroProjetoService.adicionarMembroAoProjeto(projetoId, dto.usuarioId(), dto.papeisIds());
    }

    @GetMapping(value={"/{projetoId}/tarefas"})
    public List<Tarefa> listarTarefasDoProjeto(@PathVariable Long projetoId) {
        return this.tarefaRepository.findByResponsavelProjetoId(projetoId);
    }
}

