/*
 * Decompiled with CFR 0.152.
 */
package br.com.okeaproject.project.controller;

import br.com.okeaproject.project.dto.NovoPapelDTO;
import br.com.okeaproject.project.entity.Papel;
import br.com.okeaproject.project.entity.TarefaPadrao;
import br.com.okeaproject.project.repository.PapelRepository;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/papeis"})
public class PapelController {
    @Autowired
    private PapelRepository papelRepository;

    @PostMapping
    public Papel criarPapelComTemplate(@RequestBody NovoPapelDTO dto) {
        Papel papel = new Papel();
        papel.setNome(dto.nome());
        papel.setDescricao(dto.descricao());
        ArrayList tarefas = new ArrayList();
        if (dto.tarefas() != null) {
            dto.tarefas().forEach(t -> {
                TarefaPadrao tp = new TarefaPadrao();
                tp.setNome(t.nome());
                tp.setDuracaoHoras(t.duracaoHoras());
                tp.setOrdem(t.ordem());
                tp.setDiasDefasagem(t.diasDefasagem());
                tp.setTipoPrecedencia(t.tipoPrecedencia());
                tp.setPapelDono(papel);
                tarefas.add(tp);
            });
        }
        papel.setTarefasModelo(tarefas);
        return (Papel)this.papelRepository.save((Object)papel);
    }

    @GetMapping
    public List<Papel> listarPapeis() {
        return this.papelRepository.findAll();
    }

    @PutMapping
    public Papel atualizarPapel(@RequestBody Papel papel) {
        return (Papel)this.papelRepository.save((Object)papel);
    }
}

